%% Elaborazione dei dati per il calcolo delle FRF sperimentali

% f=[0.1 0.15 0.22 0.32 0.47 0.69 1 1.5 2.2 3.2 4.7 6.9 10 15 22 32 47 70 102 150];
% 
% ff=20;
% f=150;
% 
% acq = xlsread('020.xlsx');
% 
% 
% t=5/f;
% dt=1/4000;
% 
% 
% time=acq(:,1);
% 
% time0=time(1);
% 
% for i=1:length(time)
%     time(i)=time(i)-time0;
% end
% 
% P_1=acq(:,2);
% P_2=acq(:,3);
% Spool_FB=acq(:,4);
% Spool_Cmd=acq(:,5);
% Load=acq(:,6);
% Load_Set=acq(:,7);
% e=Load_Set-Load;
% 
% %%
% % 
% % plot(time,Load)
% % hold on
% % plot(time,Load_Set)
% 
% %%
% close all
% for i=2:length(Load_Set)-1
%     
%     % inizio sinusoide
%     if Load_Set(i)==0 && (Load_Set(i+1)<0 || Load_Set(i+1)>0)  
%        j=i;
%     end
%     
% end
% 
% for i=1:length(Load_Set)-j
%     Load_Set1(i)=Load_Set(j-1+i);
% end
% 
% for i=1:length(Load)-j
%     Load1(i)=Load(j-1+i);
% end
% 
% for i=1:length(time)-j
%     time1(i)=time(j-1+i);
% end
% 
% time0=time1(1);
% 
% for i=1:length(time1)
%     time1(i)=time1(i)-time0;
% end
% 
% % fine sinusoide
% 
% for i=1:length(time1)-1
%     if time1(i)==t || (time1(i+1)>t && time1(i)<t)
%         k=i;
%     end
% end
% 
% 
% for i=1:k
%     Load_Set2(i)=Load_Set1(i);
% end
% 
% for i=1:k
%     Load2(i)=Load1(i);
% end
% 
% for i=1:k
%     time2(i)=time1(i);
% end
% 
% plot(time2,Load_Set2)
% hold on
% plot(time2,Load2)

%% FRF sperimentale calcolo ampiezza e fase

% Re_in = 2/time2(end)*trapz(time2,sin(2*pi*f*time2).*(Load_Set2));
% Im_in = 2/time2(end)*trapz(time2,cos(2*pi*f*time2).*(Load_Set2));
% amp_in = sqrt(Re_in^2+Im_in^2);
% phase_in = angle(Re_in+1i*Im_in);
% 
% % Calcolo dell'ampiezza e della fase del segnale di output
% Re_out = 2/time2(end)*trapz(time2,sin(2*pi*f*time2).*(Load2));
% Im_out = 2/time2(end)*trapz(time2,cos(2*pi*f*time2).*(Load2));
% amp_out = sqrt(Re_out^2+Im_out^2);
% phase_out = angle(Re_out+1i*Im_out);
% 
% % Calcolo il modulo e la fase della funzione di risposta in frequenza
% Mod = 20*log10(amp_out/amp_in);
% Phase = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;


%% Salvataggio su file

% load('FRF25.mat')
% 
% FRF25.Mod25(ff)=Mod;
% FRF25.Phase25(ff)=Phase;
% 
% save("FRF25.mat","FRF25","-mat")

%% 

close all
clc

dt=1/4000;

f=[0.1 0.15 0.22 0.32 0.47 0.69 1 1.5 2.2 3.2 4.7 6.9 10 15 22 32 40 47 70 102 150];


amp=5000;

for i=1:length(f)

time=linspace(0,5*1/f(i),5/f(i)*1/dt)';
StopTime=time(end);

Load_SET=10000+amp*sin(2*pi*f(i)*time);

sim("CL.slx")

Re_in = 2/time(end)*trapz(time,sin(2*pi*f(i)*time).*Load_SET);
Im_in = 2/time(end)*trapz(time,cos(2*pi*f(i)*time).*Load_SET);
amp_in = sqrt(Re_in^2+Im_in^2);
phase_in = angle(Re_in+1i*Im_in);

% Calcolo dell'ampiezza e della fase del segnale di output
Re_out = 2/tout(end)*trapz(tout,sin(2*pi*f(i)*tout).*(Load_FB));
Im_out = 2/tout(end)*trapz(tout,cos(2*pi*f(i)*tout).*(Load_FB));
amp_out = sqrt(Re_out^2+Im_out^2);
phase_out = angle(Re_out+1i*Im_out);

% Calcolo il modulo e la fase della funzione di risposta in frequenza
ModS_10(i) = 20*log10(amp_out/amp_in);
PhaseS_10(i) = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;

end


amp=9000;

for i=1:length(f)

time=linspace(0,5*1/f(i),5/f(i)*1/dt)';
StopTime=time(end);

Load_SET=10000+amp*sin(2*pi*f(i)*time);

sim("CL.slx")

Re_in = 2/time(end)*trapz(time,sin(2*pi*f(i)*time).*Load_SET);
Im_in = 2/time(end)*trapz(time,cos(2*pi*f(i)*time).*Load_SET);
amp_in = sqrt(Re_in^2+Im_in^2);
phase_in = angle(Re_in+1i*Im_in);

% Calcolo dell'ampiezza e della fase del segnale di output
Re_out = 2/tout(end)*trapz(tout,sin(2*pi*f(i)*tout).*(Load_FB));
Im_out = 2/tout(end)*trapz(tout,cos(2*pi*f(i)*tout).*(Load_FB));
amp_out = sqrt(Re_out^2+Im_out^2);
phase_out = angle(Re_out+1i*Im_out);

% Calcolo il modulo e la fase della funzione di risposta in frequenza
ModS_18(i) = 20*log10(amp_out/amp_in);
PhaseS_18(i) = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;

end

amp=2500;

for i=1:length(f)

time=linspace(0,5/f(i),5/f(i)*1/dt)';
StopTime=time(end);

Load_SET=10000+amp*sin(2*pi*f(i)*time);

sim("CL.slx")

Re_in = 2/time(end)*trapz(time,sin(2*pi*f(i)*time).*Load_SET);
Im_in = 2/time(end)*trapz(time,cos(2*pi*f(i)*time).*Load_SET);
amp_in = sqrt(Re_in^2+Im_in^2);
phase_in = angle(Re_in+1i*Im_in);

% Calcolo dell'ampiezza e della fase del segnale di output
Re_out = 2/tout(end)*trapz(tout,sin(2*pi*f(i)*tout).*(Load_FB));
Im_out = 2/tout(end)*trapz(tout,cos(2*pi*f(i)*tout).*(Load_FB));
amp_out = sqrt(Re_out^2+Im_out^2);
phase_out = angle(Re_out+1i*Im_out);

% Calcolo il modulo e la fase della funzione di risposta in frequenza
ModS_5(i) = 20*log10(amp_out/amp_in);
PhaseS_5(i) = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;

end

%%
close all


load('FRF5.mat')
load('FRF10.mat')
load('FRF18.mat')



f5=[0.1 0.15 0.22 0.32 0.47 0.69 1 1.5 2.2 3.2 4.7 6.9 10 15 22 32 47 70 90 102 150];
f10=[0.1 0.15 0.22 0.32 0.47 0.69 1 1.5 2.2 3.2 4.7 6.9 10 15 22 32 47 70 102 150];
f18=[0.1 0.15 0.22 0.32 0.47 0.69 1 1.5 2.2 3.2 4.7 6.9 10 15 22 32 47 70 102 150];


tiledlayout(2,1);
nexttile
semilogx(f5,FRF5.Mod5,'-o')
hold on
semilogx(f5,ModS_5,LineWidth=2)
hold on
semilogx(f5,-3*ones(length(FRF5.Mod5)),'LineWidth',2,'Color','#EDB120')
grid on
legend('5% sperimentale','5% simulato')
ylabel('|F_{Fb}/F_{Set}|_{dB}')
xlabel('f [Hz]')
set(gca,'FontSize',14)

nexttile
semilogx(f5,FRF5.Phase5,'-o')
hold on
semilogx(f5,PhaseS_5,LineWidth=2)
grid on
legend('5% sperimentale','5% simulato')
ylabel('φ [°]')
xlabel('f [Hz]')
set(gca,'FontSize',14)

figure(2)

tiledlayout(2,1);
nexttile
semilogx(f10,FRF10.Mod10,'-o')
hold on
semilogx(f10,ModS_10,LineWidth=2)
hold on
semilogx(f5,-3*ones(length(FRF5.Mod5)),'LineWidth',2,'Color','#EDB120')
grid on
legend('10% sperimentale','10% simulato')
ylabel('|F_{Fb}/F_{Set}|_{dB}')
xlabel('f [Hz]')
set(gca,'FontSize',14)

nexttile
semilogx(f10,FRF10.Phase10,'-o')
hold on
semilogx(f10,PhaseS_10,LineWidth=2)
grid on
legend('10% sperimentale','10% simulato')
ylabel('φ [°]')
xlabel('f [Hz]')
set(gca,'FontSize',14)


figure(3)

tiledlayout(2,1);
nexttile
semilogx(f18,FRF18.Mod18,'-o')
hold on
semilogx(f18,ModS_18,LineWidth=2)
hold on
semilogx(f5,-3*ones(length(FRF5.Mod5)),'LineWidth',2,'Color','#EDB120')
grid on
legend('18% sperimentale','18% simulato')
ylabel('|F_{Fb}/F_{Set}|_{dB}')
xlabel('f [Hz]')
set(gca,'FontSize',14)

nexttile
semilogx(f18,FRF18.Phase18,'-o')
hold on
semilogx(f18,PhaseS_18,LineWidth=2)
grid on
legend('18% sperimentale','18% simulato')
ylabel('φ [°]')
xlabel('f [Hz]')
set(gca,'FontSize',14)
